/**
 * Scripting for Mobile Center welcome page with connection instructions.
 */

$(document).ready(function ()
{
    var deviceImageFallbackTimer = null;

    var deviceImage = $('#device-image');
    var tabHeads = $('.tab-wrapper .tabs');
    var tabPanes = $('.tab');

    $('.tab-wrapper .tabs a').click(
        function ()
        {
            var appTabHead = $(this);
            var appTabPane = $(appTabHead.attr('href'));
            var appClass = appTabHead.attr('href').replace(/#/, '.');

            deviceImage.find('.fallback').removeClass('fallback');

            if (tabPanes.is(':visible')) {
                if (appTabPane.is(':visible')) {
                    // Clicked on head of currently visible tab, hide it.

                    deviceImage.find('.default').addClass('fallback');

                    appTabPane.slideUp(null, function ()
                    {
                        appTabHead.removeClass('opened');
                        tabHeads.removeClass('opened');
                        $('.tab-wrapper').css('height', '1px');
                    });
                } else {
                    // Clicked of head of tab different to currently visible.

                    deviceImage.find(appClass).addClass('fallback');

                    var prevTabHead = tabHeads.find('.opened');
                    prevTabHead.removeClass('opened');
                    $(prevTabHead.attr('href')).fadeOut();

                    appTabHead.addClass('opened');
                    appTabPane.fadeIn();
                }
            } else {
                // No tab was previously open
                deviceImage.find(appClass).addClass('fallback');

                var height = $('.tab-wrapper .tab').height();
                $('.tab-wrapper').css('height', String(height) + 'px');

                appTabHead.addClass('opened');
                tabHeads.addClass('opened');
                appTabPane.slideDown();
            }
            return false;
        }).mouseenter(
        function ()
        {
            var app = $(this).attr('href').replace(/#/, '.');
            var deviceImageApp = deviceImage.find(app);
            if (deviceImageApp.is(':visible')) {
                return;
            }

            if (deviceImageFallbackTimer != null) {
                clearTimeout(deviceImageFallbackTimer);
            }

            deviceImage.find('div:visible').fadeOut(300);
            deviceImageApp.fadeIn(300);
        }).mouseleave(
        function ()
        {
            deviceImageFallbackTimer = setTimeout(function ()
            {
                var fallbackDeviceImage = deviceImage.find('.fallback');
                if (fallbackDeviceImage.is(':visible')) {
                    return;
                }
                deviceImageFallbackTimer = null;
                deviceImage.find('div:visible').fadeOut(300);
                fallbackDeviceImage.fadeIn(300);
            }, 400);
        });

    $('.tab-wrapper > h2, .tab-wrapper .tab').hide();
    $('.tab-wrapper').addClass('js');
    $(function ()
    {
        $('.mobile-connector-url').html(document.location.hostname);
    });

    // Preload images
    deviceImage.find('div').each(function ()
    {
        var imgUrl = $(this).css('background-image');
        imgUrl = /^url\((['"]?)(.*)\1\)$/.exec(imgUrl);
        imgUrl = imgUrl ? imgUrl[2] : ""; // If matched, retrieve url, otherwise ""    });
        new Image().src = imgUrl;
    });
});